/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamdimensions.commands;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.ftb.mods.ftbteamdimensions.FTBTeamDimensions;
import dev.ftb.mods.ftbteamdimensions.commands.arguments.DimensionCommandArgument;
import dev.ftb.mods.ftbteamdimensions.dimensions.DimensionsManager;
import dev.ftb.mods.ftbteamdimensions.dimensions.NetherPortalPlacement;
import dev.ftb.mods.ftbteamdimensions.dimensions.level.ArchivedDimension;
import dev.ftb.mods.ftbteamdimensions.dimensions.level.DimensionStorage;
import dev.ftb.mods.ftbteamdimensions.dimensions.level.DynamicDimensionManager;
import dev.ftb.mods.ftbteamdimensions.net.OpenVisitGui;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamType;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.PortalInfo;

public class FTBDimensionsCommands {
    private static final DynamicCommandExceptionType NOT_PARTY_TEAM = new DynamicCommandExceptionType(object -> Component.m_237110_((String)"ftbteamdimensions.message.not_a_party", (Object[])new Object[]{object}));
    private static final DynamicCommandExceptionType DIM_MISSING = new DynamicCommandExceptionType(object -> Component.m_237110_((String)"ftbteamdimensions.message.missing_dimension", (Object[])new Object[]{object}));
    private static final DynamicCommandExceptionType NO_DIM = new DynamicCommandExceptionType(object -> Component.m_237110_((String)"ftbteamdimensions.message.no_dim_for_team", (Object[])new Object[]{object}));

    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        FTBTeamDimensions.LOGGER.info("Registering FTB Dimensions Commands");
        LiteralCommandNode commands = commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ftbteamdimensions").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"visit").requires(source -> source.m_6761_(2))).executes(context -> FTBDimensionsCommands.openVisitGui((CommandSourceStack)context.getSource()))).then(Commands.m_82129_((String)"team", (ArgumentType)TeamArgument.create()).executes(context -> FTBDimensionsCommands.visitDim((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"nether-visit").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"team", (ArgumentType)TeamArgument.create()).executes(context -> FTBDimensionsCommands.visitNetherDim((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"list-dimensions").requires(source -> source.m_6761_(2))).executes(context -> FTBDimensionsCommands.listDimensions((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"list-archived").requires(source -> source.m_6761_(2))).executes(context -> FTBDimensionsCommands.listArchived((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"prune-all").requires(source -> source.m_6761_(2))).executes(context -> FTBDimensionsCommands.prune((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"prune").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionCommandArgument.create()).executes(context -> FTBDimensionsCommands.prune((CommandSourceStack)context.getSource(), DimensionCommandArgument.get((CommandContext<CommandSourceStack>)context, "dimension")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"restore").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionCommandArgument.create()).executes(context -> FTBDimensionsCommands.restore((CommandSourceStack)context.getSource(), DimensionCommandArgument.get((CommandContext<CommandSourceStack>)context, "dimension"), EntityArgument.m_91474_((CommandContext)context, (String)"player"))))))).then(Commands.m_82127_((String)"lobby").executes(context -> FTBDimensionsCommands.lobby((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"home").executes(context -> FTBDimensionsCommands.home((CommandSourceStack)context.getSource()))));
        commandDispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"ftbdim").redirect((CommandNode)commands));
    }

    private static int openVisitGui(CommandSourceStack source) throws CommandSyntaxException {
        DimensionStorage storage = DimensionStorage.get(source.m_81377_());
        ImmutableMap<UUID, ResourceLocation> team2dim = storage.getTeamToDimension();
        HashMap<ResourceLocation, OpenVisitGui.DimData> dim2name = new HashMap<ResourceLocation, OpenVisitGui.DimData>();
        team2dim.keySet().forEach(dimId -> {
            ServerLevel level;
            ResourceKey<Level> key;
            Team team = FTBTeamsAPI.getManager().getTeamByID(dimId);
            if (team != null && (key = storage.getDimensionId(team)) != null && (level = source.m_81377_().m_129880_(key)) != null) {
                dim2name.put(key.m_135782_(), OpenVisitGui.DimData.create(level, team.getName().getString(), false));
            }
        });
        storage.getArchivedDimensions().forEach(dim -> {
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dim.dimensionName());
            ServerLevel level = source.m_81377_().m_129880_(key);
            if (level != null) {
                dim2name.put(dim.dimensionName(), OpenVisitGui.DimData.create(level, dim.teamName(), true));
            }
        });
        if (dim2name.isEmpty()) {
            source.m_81352_((Component)Component.m_237115_((String)"ftbteamdimensions.message.no_dimensions"));
            return -1;
        }
        new OpenVisitGui(dim2name).sendTo(source.m_81375_());
        return 1;
    }

    public static PartyTeam createPartyTeam(ServerPlayer player) throws CommandSyntaxException {
        Consumer o = FTBTeamsAPI.partyCreationOverride;
        FTBTeamsAPI.partyCreationOverride = null;
        PartyTeam party = (PartyTeam)FTBTeamsAPI.getManager().createParty(player, player.m_7755_().getString() + " Party").getValue();
        FTBTeamsAPI.partyCreationOverride = o;
        return party;
    }

    private static int restore(CommandSourceStack source, ArchivedDimension dimension, ServerPlayer player) throws CommandSyntaxException {
        PartyTeam party = FTBDimensionsCommands.createPartyTeam(player);
        DimensionStorage storage = DimensionStorage.get(source.m_81377_());
        ResourceKey<Level> levelResourceKey = storage.putDimension((Team)party, dimension.dimensionName());
        storage.getArchivedDimensions().remove(dimension);
        storage.m_77762_();
        source.m_81377_().m_201446_(() -> DynamicDimensionManager.teleport(player, levelResourceKey));
        source.m_81354_((Component)Component.m_237110_((String)"ftbteamdimensions.message.restored", (Object[])new Object[]{dimension.dimensionName()}).m_130940_(ChatFormatting.GREEN), false);
        return 0;
    }

    private static int prune(CommandSourceStack source, ArchivedDimension dimension) throws CommandSyntaxException {
        DimensionStorage storage = DimensionStorage.get(source.m_81377_());
        List<ArchivedDimension> archivedDimensions = storage.getArchivedDimensions();
        if (!archivedDimensions.contains(dimension)) {
            throw DIM_MISSING.create((Object)dimension.dimensionName());
        }
        DynamicDimensionManager.destroy(source.m_81377_(), (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension.dimensionName()));
        archivedDimensions.remove(dimension);
        storage.m_77762_();
        source.m_81354_((Component)Component.m_237110_((String)"ftbteamdimensions.message.pruned_one", (Object[])new Object[]{dimension.dimensionName()}).m_130940_(ChatFormatting.GREEN), false);
        return 0;
    }

    private static int prune(CommandSourceStack source) {
        MinecraftServer server = source.m_81377_();
        DimensionStorage storage = DimensionStorage.get(source.m_81377_());
        List<ArchivedDimension> archivedDimensions = storage.getArchivedDimensions();
        int size = archivedDimensions.size();
        for (ArchivedDimension e : archivedDimensions) {
            DynamicDimensionManager.destroy(server, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)e.dimensionName()));
        }
        storage.getArchivedDimensions().clear();
        storage.m_77762_();
        source.m_81354_((Component)Component.m_237110_((String)"ftbteamdimensions.message.pruned_all", (Object[])new Object[]{size}).m_130940_(ChatFormatting.GREEN), false);
        return 0;
    }

    private static int listDimensions(CommandSourceStack source) {
        DimensionStorage storage = DimensionStorage.get(source.m_81377_());
        ImmutableMap<UUID, ResourceLocation> map = storage.getTeamToDimension();
        if (map.isEmpty()) {
            source.m_81352_((Component)Component.m_237115_((String)"ftbteamdimensions.message.no_dimensions"));
            return -1;
        }
        ImmutableSet dimIds = storage.getTeamToDimension().keySet();
        source.m_81354_((Component)Component.m_237110_((String)"ftbteamdimensions.message.dim_header", (Object[])new Object[]{dimIds.size()}).m_130940_(ChatFormatting.GREEN), false);
        dimIds.forEach(id -> {
            ResourceKey<Level> key;
            Team team = FTBTeamsAPI.getManager().getTeamByID(id);
            if (team != null && (key = storage.getDimensionId(team)) != null) {
                source.m_81354_((Component)Component.m_237113_((String)key.m_135782_().toString()).m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)": [team=%s]".formatted(team.getStringID())).m_130940_(ChatFormatting.WHITE)), false);
            }
        });
        return 0;
    }

    private static int listArchived(CommandSourceStack source) {
        List<ArchivedDimension> archivedDimensions = DimensionStorage.get(source.m_81377_()).getArchivedDimensions();
        if (archivedDimensions.isEmpty()) {
            source.m_81352_((Component)Component.m_237115_((String)"ftbteamdimensions.message.no_archived"));
            return -1;
        }
        source.m_81354_((Component)Component.m_237110_((String)"ftbteamdimensions.message.dim_header", (Object[])new Object[]{archivedDimensions.size()}).m_130940_(ChatFormatting.DARK_GREEN), false);
        for (ArchivedDimension aDim : archivedDimensions) {
            source.m_81354_((Component)Component.m_237113_((String)aDim.dimensionName().toString()).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)": [team=%s] [owner=%s]".formatted(aDim.teamName(), aDim.teamOwner())).m_130940_(ChatFormatting.GRAY)), false);
        }
        return 0;
    }

    private static int visitDim(CommandSourceStack source, Team team) throws CommandSyntaxException {
        if (team.getType() != TeamType.PARTY) {
            throw NOT_PARTY_TEAM.create((Object)team.getName().getString());
        }
        ResourceKey<Level> dimension = DimensionsManager.INSTANCE.getDimension(team);
        if (dimension == null) {
            throw NO_DIM.create((Object)team.getName().getString());
        }
        DynamicDimensionManager.teleport(source.m_81375_(), dimension);
        return 0;
    }

    private static int visitNetherDim(CommandSourceStack source, Team team) throws CommandSyntaxException {
        if (team.getType() != TeamType.PARTY) {
            throw NOT_PARTY_TEAM.create((Object)team.getName().getString());
        }
        ServerLevel nether = source.m_81377_().m_129880_(Level.f_46429_);
        if (nether == null) {
            throw DIM_MISSING.create((Object)team.getName().getString());
        }
        ServerPlayer player = source.m_81375_();
        PortalInfo portalInfo = NetherPortalPlacement.teamSpecificEntryPoint(nether, player, team);
        BlockPos pos = new BlockPos(portalInfo.f_77676_.m_7096_(), portalInfo.f_77676_.m_7098_(), portalInfo.f_77676_.m_7094_());
        ChunkPos chunkpos = new ChunkPos(pos);
        nether.m_7726_().m_8387_(TicketType.f_9448_, chunkpos, 1, (Object)player.m_19879_());
        player.m_8127_();
        if (player.m_5803_()) {
            player.m_6145_(true, true);
        }
        player.m_8999_(nether, portalInfo.f_77676_.m_7096_() + 0.5, portalInfo.f_77676_.m_7098_() + 0.01, portalInfo.f_77676_.m_7094_() + 0.5, player.m_146908_(), player.m_146909_());
        player.m_20091_();
        return 0;
    }

    private static int lobby(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        if (DynamicDimensionManager.teleport(player, (ResourceKey<Level>)Level.f_46428_)) {
            return 1;
        }
        return 0;
    }

    private static int home(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        Team team = FTBTeamsAPI.getPlayerTeam((ServerPlayer)player);
        if (team.getType().isParty() && DynamicDimensionManager.teleport(player, DimensionsManager.INSTANCE.getDimension((Player)player))) {
            return 1;
        }
        source.m_81352_((Component)Component.m_237115_((String)"ftbteamdimensions.message.cant_teleport"));
        return 0;
    }
}

